<?php
/**
 * The Header: Logo and main menu
 *
 * @package RIFF
 * @since RIFF 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( riff_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'riff_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'riff_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('riff_action_body_wrap_attributes'); ?>>

		<?php do_action( 'riff_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'riff_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('riff_action_page_wrap_attributes'); ?>>

			<?php do_action( 'riff_action_page_wrap_start' ); ?>

			<?php
			$riff_full_post_loading = ( riff_is_singular( 'post' ) || riff_is_singular( 'attachment' ) ) && riff_get_value_gp( 'action' ) == 'full_post_loading';
			$riff_prev_post_loading = ( riff_is_singular( 'post' ) || riff_is_singular( 'attachment' ) ) && riff_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $riff_full_post_loading && ! $riff_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="riff_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'riff_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'riff' ); ?></a>
				<?php if ( riff_sidebar_present() ) { ?>
				<a class="riff_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'riff_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'riff' ); ?></a>
				<?php } ?>
				<a class="riff_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'riff_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'riff' ); ?></a>

				<?php
				do_action( 'riff_action_before_header' );

				// Header
				$riff_header_type = riff_get_theme_option( 'header_type' );
				if ( 'custom' == $riff_header_type && ! riff_is_layouts_available() ) {
					$riff_header_type = 'default';
				}
				get_template_part( apply_filters( 'riff_filter_get_template_part', "templates/header-" . sanitize_file_name( $riff_header_type ) ) );

				// Side menu
				if ( in_array( riff_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'riff_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'riff_action_after_header' );

			}
			?>

			<?php do_action( 'riff_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( riff_is_off( riff_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $riff_header_type ) ) {
						$riff_header_type = riff_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $riff_header_type && riff_is_layouts_available() ) {
						$riff_header_id = riff_get_custom_header_id();
						if ( $riff_header_id > 0 ) {
							$riff_header_meta = riff_get_custom_layout_meta( $riff_header_id );
							if ( ! empty( $riff_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$riff_footer_type = riff_get_theme_option( 'footer_type' );
					if ( 'custom' == $riff_footer_type && riff_is_layouts_available() ) {
						$riff_footer_id = riff_get_custom_footer_id();
						if ( $riff_footer_id ) {
							$riff_footer_meta = riff_get_custom_layout_meta( $riff_footer_id );
							if ( ! empty( $riff_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'riff_action_page_content_wrap_class', $riff_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'riff_filter_is_prev_post_loading', $riff_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( riff_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'riff_action_page_content_wrap_data', $riff_prev_post_loading );
			?>>
				<?php
				do_action( 'riff_action_page_content_wrap', $riff_full_post_loading || $riff_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'riff_filter_single_post_header', riff_is_singular( 'post' ) || riff_is_singular( 'attachment' ) ) ) {
					if ( $riff_prev_post_loading ) {
						if ( riff_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'riff_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$riff_path = apply_filters( 'riff_filter_get_template_part', 'templates/single-styles/' . riff_get_theme_option( 'single_style' ) );
					if ( riff_get_file_dir( $riff_path . '.php' ) != '' ) {
						get_template_part( $riff_path );
					}
				}

				// Widgets area above page
				$riff_body_style   = riff_get_theme_option( 'body_style' );
				$riff_widgets_name = riff_get_theme_option( 'widgets_above_page', 'hide' );
				$riff_show_widgets = ! riff_is_off( $riff_widgets_name ) && is_active_sidebar( $riff_widgets_name );
				if ( $riff_show_widgets ) {
					if ( 'fullscreen' != $riff_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					riff_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $riff_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'riff_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $riff_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'riff_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'riff_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="riff_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( riff_is_singular( 'post' ) || riff_is_singular( 'attachment' ) )
							&& $riff_prev_post_loading 
							&& riff_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'riff_action_between_posts' );
						}

						// Widgets area above content
						riff_create_widgets_area( 'widgets_above_content' );

						do_action( 'riff_action_page_content_start_text' );
