<?php
/**
 * The template to display single post
 *
 * @package RIFF
 * @since RIFF 1.0
 */

// Full post loading
$full_post_loading          = riff_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = riff_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = riff_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$riff_related_position   = riff_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$riff_posts_navigation   = riff_get_theme_option( 'posts_navigation' );
$riff_prev_post          = false;
$riff_prev_post_same_cat = (int)riff_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( riff_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	riff_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'riff_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $riff_posts_navigation ) {
		$riff_prev_post = get_previous_post( $riff_prev_post_same_cat );  // Get post from same category
		if ( ! $riff_prev_post && $riff_prev_post_same_cat ) {
			$riff_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $riff_prev_post ) {
			$riff_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $riff_prev_post ) ) {
		riff_sc_layouts_showed( 'featured', false );
		riff_sc_layouts_showed( 'title', false );
		riff_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $riff_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/content', 'single-' . riff_get_theme_option( 'single_style' ) ), 'single-' . riff_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $riff_related_position, 'inside' ) === 0 ) {
		$riff_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'riff_action_related_posts' );
		$riff_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $riff_related_content ) ) {
			$riff_related_position_inside = max( 0, min( 9, riff_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $riff_related_position_inside ) {
				$riff_related_position_inside = mt_rand( 1, 9 );
			}

			$riff_p_number         = 0;
			$riff_related_inserted = false;
			$riff_in_block         = false;
			$riff_content_start    = strpos( $riff_content, '<div class="post_content' );
			$riff_content_end      = strrpos( $riff_content, '</div>' );

			for ( $i = max( 0, $riff_content_start ); $i < min( strlen( $riff_content ) - 3, $riff_content_end ); $i++ ) {
				if ( $riff_content[ $i ] != '<' ) {
					continue;
				}
				if ( $riff_in_block ) {
					if ( strtolower( substr( $riff_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$riff_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $riff_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $riff_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$riff_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $riff_content[ $i + 1 ] && in_array( $riff_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$riff_p_number++;
					if ( $riff_related_position_inside == $riff_p_number ) {
						$riff_related_inserted = true;
						$riff_content = ( $i > 0 ? substr( $riff_content, 0, $i ) : '' )
											. $riff_related_content
											. substr( $riff_content, $i );
					}
				}
			}
			if ( ! $riff_related_inserted ) {
				if ( $riff_content_end > 0 ) {
					$riff_content = substr( $riff_content, 0, $riff_content_end ) . $riff_related_content . substr( $riff_content, $riff_content_end );
				} else {
					$riff_content .= $riff_related_content;
				}
			}
		}

		riff_show_layout( $riff_content );
	}

	// Comments
	do_action( 'riff_action_before_comments' );
	comments_template();
	do_action( 'riff_action_after_comments' );

	// Related posts
	if ( 'below_content' == $riff_related_position
		&& ( 'scroll' != $riff_posts_navigation || (int)riff_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)riff_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'riff_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $riff_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $riff_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $riff_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $riff_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'riff_action_nav_links_single_scroll_data', $riff_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
