<?php
/**
 * The template to display Admin notices
 *
 * @package RIFF
 * @since RIFF 1.0.1
 */

$riff_theme_slug = get_option( 'template' );
$riff_theme_obj  = wp_get_theme( $riff_theme_slug );
?>
<div class="riff_admin_notice riff_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$riff_theme_img = riff_get_file_url( 'screenshot.jpg' );
	if ( '' != $riff_theme_img ) {
		?>
		<div class="riff_notice_image"><img src="<?php echo esc_url( $riff_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'riff' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="riff_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'riff' ),
				$riff_theme_obj->get( 'Name' ) . ( RIFF_THEME_FREE ? ' ' . __( 'Free', 'riff' ) : '' ),
				$riff_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="riff_notice_text">
		<p class="riff_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $riff_theme_obj->description ) );
			?>
		</p>
		<p class="riff_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'riff' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="riff_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=riff_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'riff' );
			?>
		</a>
	</div>
</div>
