<?php
/**
 * The template to display default site footer
 *
 * @package RIFF
 * @since RIFF 1.0.10
 */

$riff_footer_id = riff_get_custom_footer_id();
$riff_footer_meta = get_post_meta( $riff_footer_id, 'trx_addons_options', true );
if ( ! empty( $riff_footer_meta['margin'] ) ) {
	riff_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( riff_prepare_css_value( $riff_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $riff_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $riff_footer_id ) ) ); ?>
						<?php
						$riff_footer_scheme = riff_get_theme_option( 'footer_scheme' );
						if ( ! empty( $riff_footer_scheme ) && ! riff_is_inherit( $riff_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $riff_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'riff_action_show_layout', $riff_footer_id );
	?>
</footer><!-- /.footer_wrap -->
