<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package RIFF
 * @since RIFF 1.0
 */

// Page (category, tag, archive, author) title

if ( riff_need_page_title() ) {
	riff_sc_layouts_showed( 'title', true );
	riff_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								riff_show_post_meta(
									apply_filters(
										'riff_filter_post_meta_args', array(
											'components' => join( ',', riff_array_get_keys_by_value( riff_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', riff_array_get_keys_by_value( riff_get_theme_option( 'counters' ) ) ),
											'seo'        => riff_is_on( riff_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$riff_blog_title           = riff_get_blog_title();
							$riff_blog_title_text      = '';
							$riff_blog_title_class     = '';
							$riff_blog_title_link      = '';
							$riff_blog_title_link_text = '';
							if ( is_array( $riff_blog_title ) ) {
								$riff_blog_title_text      = $riff_blog_title['text'];
								$riff_blog_title_class     = ! empty( $riff_blog_title['class'] ) ? ' ' . $riff_blog_title['class'] : '';
								$riff_blog_title_link      = ! empty( $riff_blog_title['link'] ) ? $riff_blog_title['link'] : '';
								$riff_blog_title_link_text = ! empty( $riff_blog_title['link_text'] ) ? $riff_blog_title['link_text'] : '';
							} else {
								$riff_blog_title_text = $riff_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $riff_blog_title_class ); ?>">
								<?php
								$riff_top_icon = riff_get_term_image_small();
								if ( ! empty( $riff_top_icon ) ) {
									$riff_attr = riff_getimagesize( $riff_top_icon );
									?>
									<img src="<?php echo esc_url( $riff_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'riff' ); ?>"
										<?php
										if ( ! empty( $riff_attr[3] ) ) {
											riff_show_layout( $riff_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $riff_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $riff_blog_title_link ) && ! empty( $riff_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $riff_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $riff_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'riff_action_breadcrumbs' );
						$riff_breadcrumbs = ob_get_contents();
						ob_end_clean();
						riff_show_layout( $riff_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
