<div class="front_page_section front_page_section_about<?php
	$riff_scheme = riff_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $riff_scheme ) && ! riff_is_inherit( $riff_scheme ) ) {
		echo ' scheme_' . esc_attr( $riff_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( riff_get_theme_option( 'front_page_about_paddings' ) );
	if ( riff_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$riff_css      = '';
		$riff_bg_image = riff_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $riff_bg_image ) ) {
			$riff_css .= 'background-image: url(' . esc_url( riff_get_attachment_url( $riff_bg_image ) ) . ');';
		}
		if ( ! empty( $riff_css ) ) {
			echo ' style="' . esc_attr( $riff_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$riff_anchor_icon = riff_get_theme_option( 'front_page_about_anchor_icon' );
	$riff_anchor_text = riff_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $riff_anchor_icon ) || ! empty( $riff_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $riff_anchor_icon ) ? ' icon="' . esc_attr( $riff_anchor_icon ) . '"' : '' )
									. ( ! empty( $riff_anchor_text ) ? ' title="' . esc_attr( $riff_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( riff_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' riff-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$riff_css           = '';
			$riff_bg_mask       = riff_get_theme_option( 'front_page_about_bg_mask' );
			$riff_bg_color_type = riff_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $riff_bg_color_type ) {
				$riff_bg_color = riff_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $riff_bg_color_type ) {
				$riff_bg_color = riff_get_scheme_color( 'bg_color', $riff_scheme );
			} else {
				$riff_bg_color = '';
			}
			if ( ! empty( $riff_bg_color ) && $riff_bg_mask > 0 ) {
				$riff_css .= 'background-color: ' . esc_attr(
					1 == $riff_bg_mask ? $riff_bg_color : riff_hex2rgba( $riff_bg_color, $riff_bg_mask )
				) . ';';
			}
			if ( ! empty( $riff_css ) ) {
				echo ' style="' . esc_attr( $riff_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$riff_caption = riff_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $riff_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $riff_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $riff_caption, 'riff_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$riff_description = riff_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $riff_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $riff_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $riff_description ), 'riff_kses_content' ); ?></div>
				<?php
			}

			// Content
			$riff_content = riff_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $riff_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $riff_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$riff_page_content_mask = '%%CONTENT%%';
					if ( strpos( $riff_content, $riff_page_content_mask ) !== false ) {
						$riff_content = preg_replace(
							'/(\<p\>\s*)?' . $riff_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$riff_content
						);
					}
					riff_show_layout( $riff_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
