<?php
$riff_slider_sc = riff_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $riff_slider_sc ) && strpos( $riff_slider_sc, '[' ) !== false && strpos( $riff_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( riff_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$riff_anchor_icon = riff_get_theme_option( 'front_page_title_anchor_icon' );
		$riff_anchor_text = riff_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $riff_anchor_icon ) || ! empty( $riff_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $riff_anchor_icon ) ? ' icon="' . esc_attr( $riff_anchor_icon ) . '"' : '' )
									. ( ! empty( $riff_anchor_text ) ? ' title="' . esc_attr( $riff_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $riff_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$riff_scheme = riff_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $riff_scheme ) && ! riff_is_inherit( $riff_scheme ) ) {
			echo ' scheme_' . esc_attr( $riff_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( riff_get_theme_option( 'front_page_title_paddings' ) );
		if ( riff_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$riff_css      = '';
		$riff_bg_image = riff_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $riff_bg_image ) ) {
			$riff_css .= 'background-image: url(' . esc_url( riff_get_attachment_url( $riff_bg_image ) ) . ');';
		}
		if ( ! empty( $riff_css ) ) {
			echo ' style="' . esc_attr( $riff_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$riff_anchor_icon = riff_get_theme_option( 'front_page_title_anchor_icon' );
		$riff_anchor_text = riff_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $riff_anchor_icon ) || ! empty( $riff_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $riff_anchor_icon ) ? ' icon="' . esc_attr( $riff_anchor_icon ) . '"' : '' )
									. ( ! empty( $riff_anchor_text ) ? ' title="' . esc_attr( $riff_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( riff_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' riff-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$riff_css      = '';
			$riff_bg_mask  = riff_get_theme_option( 'front_page_title_bg_mask' );
			$riff_bg_color_type = riff_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $riff_bg_color_type ) {
				$riff_bg_color = riff_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $riff_bg_color_type ) {
				$riff_bg_color = riff_get_scheme_color( 'bg_color', $riff_scheme );
			} else {
				$riff_bg_color = '';
			}
			if ( ! empty( $riff_bg_color ) && $riff_bg_mask > 0 ) {
				$riff_css .= 'background-color: ' . esc_attr(
					1 == $riff_bg_mask ? $riff_bg_color : riff_hex2rgba( $riff_bg_color, $riff_bg_mask )
				) . ';';
			}
			if ( ! empty( $riff_css ) ) {
				echo ' style="' . esc_attr( $riff_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$riff_caption = riff_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $riff_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $riff_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $riff_caption, 'riff_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$riff_description = riff_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $riff_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $riff_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $riff_description ), 'riff_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( riff_get_theme_option( 'front_page_title_button1_link' ) != '' || riff_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						riff_show_layout( riff_customizer_partial_refresh_front_page_title_button1_link() );
						riff_show_layout( riff_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
