<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package RIFF
 * @since RIFF 1.0
 */

if ( riff_sidebar_present() ) {
	
	$riff_sidebar_type = riff_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $riff_sidebar_type && ! riff_is_layouts_available() ) {
		$riff_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $riff_sidebar_type ) {
		// Default sidebar with widgets
		$riff_sidebar_name = riff_get_theme_option( 'sidebar_widgets' );
		riff_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $riff_sidebar_name ) ) {
			dynamic_sidebar( $riff_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$riff_sidebar_id = riff_get_custom_sidebar_id();
		do_action( 'riff_action_show_layout', $riff_sidebar_id );
	}
	$riff_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $riff_out ) ) {
		$riff_sidebar_position    = riff_get_theme_option( 'sidebar_position' );
		$riff_sidebar_position_ss = riff_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $riff_sidebar_position );
			echo ' sidebar_' . esc_attr( $riff_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $riff_sidebar_type );

			$riff_sidebar_scheme = apply_filters( 'riff_filter_sidebar_scheme', riff_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $riff_sidebar_scheme ) && ! riff_is_inherit( $riff_sidebar_scheme ) && 'custom' != $riff_sidebar_type ) {
				echo ' scheme_' . esc_attr( $riff_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="riff_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'riff_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $riff_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$riff_title = apply_filters( 'riff_filter_sidebar_control_title', 'float' == $riff_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'riff' ) : '' );
				$riff_text  = apply_filters( 'riff_filter_sidebar_control_text', 'above' == $riff_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'riff' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $riff_title ); ?>"><?php echo esc_html( $riff_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'riff_action_before_sidebar', 'sidebar' );
				riff_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $riff_out ) );
				do_action( 'riff_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'riff_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
