<?php
/* Event Tickets support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('riff_event_tickets_theme_setup9')) {
	add_action( 'after_setup_theme', 'riff_event_tickets_theme_setup9', 9 );
	function riff_event_tickets_theme_setup9() {
		if (riff_exists_event_tickets()) {
			add_action( 'wp_enqueue_scripts', 'riff_event_tickets_frontend_scripts', 1500 );
			add_action( 'wp_enqueue_scripts', 'riff_event_tickets_frontend_scripts_responsive', 2000 );
			add_filter( 'riff_filter_merge_styles', 'riff_event_tickets_merge_styles' );
			add_filter( 'riff_filter_merge_styles_responsive', 'riff_event_tickets_merge_styles_responsive' );
		}
		if (is_admin()) {
			add_filter( 'riff_filter_tgmpa_required_plugins', 'riff_event_tickets_tgmpa_required_plugins' );
		}
	}
}



// Filter to add in the required plugins list
if ( !function_exists( 'riff_event_tickets_tgmpa_required_plugins' ) ) {
	function riff_event_tickets_tgmpa_required_plugins($list=array()) {
		if (riff_storage_isset('required_plugins', 'event-tickets') && riff_storage_get_array( 'required_plugins', 'event-tickets', 'install' ) !== false) {
			$list[] = array(
				'name' 		=> riff_storage_get_array('required_plugins', 'event-tickets', 'title'),
				'slug' 		=> 'event-tickets',
				'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'riff_exists_event_tickets' ) ) {
    function riff_exists_event_tickets() {
        return class_exists( 'Tribe__Tickets__Main' );
    }
}

// Enqueue custom scripts
if ( ! function_exists( 'riff_event_tickets_frontend_scripts' ) ) {
	function riff_event_tickets_frontend_scripts() {
		if ( riff_is_on( riff_get_theme_option( 'debug_mode' ) ) ) {
			$riff_url = riff_get_file_url( 'plugins/event-tickets/event-tickets.css' );
			if ( '' != $riff_url ) {
				wp_enqueue_style( 'riff-event-tickets', $riff_url, array(), null );
			}
		}
	}
}

// Enqueue responsive styles for frontend
if ( ! function_exists( 'riff_event_tickets_frontend_scripts_responsive' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'riff_event_tickets_frontend_scripts_responsive', 2000 );
	function riff_event_tickets_frontend_scripts_responsive() {
		if ( riff_is_on( riff_get_theme_option( 'debug_mode' ) ) ) {
			$riff_url = riff_get_file_url( 'plugins/event-tickets/event-tickets-responsive.css' );
			if ( '' != $riff_url ) {
				wp_enqueue_style( 'riff-event-tickets-responsive', $riff_url, array(), null, riff_media_for_load_css_responsive( 'event-tickets' ) );
			}
		}
	}
}


// Merge custom styles
if ( ! function_exists( 'riff_event_tickets_merge_styles' ) ) {
	function riff_event_tickets_merge_styles( $list ) {
		$list['plugins/event-tickets/event-tickets.css'] = true;
		return $list;
	}
}


// Merge responsive styles
if ( ! function_exists( 'riff_event_tickets_merge_styles_responsive' ) ) {
	//Handler of the add_filter('palatio_filter_merge_styles_responsive', 'riff_event_tickets_merge_styles_responsive');
	function riff_event_tickets_merge_styles_responsive( $list ) {
		$list['plugins/event-tickets/event-tickets-responsive.css'] = true;
		
		return $list;
	}
}
