<?php
/**
 * Skin Setup
 *
 * @package RIFF
 * @since RIFF 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'riff_theme_defaults' ) ) {
	function riff_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'riff_skin_woocommerce_allow_extensions' ) ) {
	add_filter( 'riff_filter_load_woocommerce_extensions', 'riff_skin_woocommerce_allow_extensions' );
	function riff_skin_woocommerce_allow_extensions( $allow ) {
		return false;
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'riff_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'riff_skin_setup', 1 );
	function riff_skin_setup() {

		$GLOBALS['RIFF_STORAGE'] = array_merge( $GLOBALS['RIFF_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-ancora',

			'theme_doc_url'       => '//doc.themerex.net/riff/',

			'theme_demofiles_url' => '//demofiles.ancorathemes.com/riff/',
			
			'theme_rate_url'      => '//themeforest.net/downloads',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			'theme_video_url'     => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',   // Ancora

			'theme_privacy_url'   => '//ancorathemes.com/privacy-policy/',                   // Ancora

			'portfolio_url'       => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'riff_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'riff_skin_setup_settings', 1 );
	function riff_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		riff_storage_set_array( 'settings', 'thumbs_in_navigation', false );
		riff_storage_set_array2( 'required_plugins', 'woocommerce', 'install', true );
		riff_storage_set_array2( 'required_plugins', 'ti-woocommerce-wishlist', 'install', true );
		riff_storage_set_array2( 'required_plugins', 'the-events-calendar', 'install', true );
 		riff_storage_set_array( 'required_plugins', 'event-tickets', array(
 			'title'       => esc_html__( 'Event Tickets and Registration', 'riff' ),
 			'description' => esc_html__( 'Event Tickets allows you to sell basic tickets and collect RSVPs from any post, page, or event', 'riff' ),
 			'required'    => false,
 			'logo'        => riff_get_file_url( 'plugins/event-tickets/event-tickets.png' ),
 			'group'       => 'other',
 		));
 		$riff_skin_path = riff_get_file_dir( riff_skins_get_current_skin_dir() . 'plugins/event-tickets/event-tickets.php' );
 		if ( ! empty( $riff_skin_path ) ) {
 			require_once $riff_skin_path;
 		}
	}
}

// Update Theme Options elements
if ( ! function_exists( 'riff_skin_options_theme_setup2' ) ) {
	add_action( 'after_setup_theme', 'riff_skin_options_theme_setup2', 4 );
	function riff_skin_options_theme_setup2() {
		riff_storage_set_array2( 'options', 'footer_scheme', 'std', 'dark');
	}
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'riff_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'riff_skin_setup_fonts', 1 );
	function riff_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		riff_storage_set(
			'load_fonts', array(
				// Google font
				array(
					'name'   => 'Poppins',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700',
				),
                array(
                    'name'   => 'Syne',
                    'family' => 'sans-serif',
                    'link'   => '',
                    'styles' => 'wght@400;500;600;700',
                )
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		riff_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => riff_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'riff' );

		riff_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'riff' ) ),
					'font-family'     => 'Poppins,sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.84em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.86em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'riff' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '3.800em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-1.7px',
					'margin-top'      => '1.1em',
					'margin-bottom'   => '0.38em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '3.133em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.77em',
					'margin-bottom'   => '0.43em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '2.333em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.15em',
					'margin-bottom'   => '0.6em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '1.867em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.42em',
					'margin-bottom'   => '0.6em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '1.600em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.417em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.42em',
					'margin-bottom'   => '0.7em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '1.267em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.474em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.75em',
					'margin-bottom'   => '0.7em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '1.7em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '21px',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'riff' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0.1px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'riff' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '13px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'riff' ) ),
					'font-family'     => 'Syne,sans-serif',
					'font-size'       => '16px',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'riff' ) ),
					'font-family'     => 'Poppins,sans-serif',
					'font-size'       => '13px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'riff' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'riff' ) ),
					'font-family'     => 'Poppins,sans-serif',
				),
			)
		);

		// Font presets
		riff_storage_set(
			'font_presets', array(
				'karla' => array(
								'title'  => esc_html__( 'Karla', 'riff' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Dancing Script',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
													// Google font
													array(
														'name'   => 'Sansita Swashed',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Dancing Script",fantasy',
														'font-size'       => '1.25rem',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
														'font-size'       => '4em',
													),
													'h2'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h3'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h4'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h5'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h6'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'logo'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'button'  => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'submenu' => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
												),
							),
				'roboto' => array(
								'title'  => esc_html__( 'Roboto', 'riff' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Noto Sans JP',
														'family' => 'serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
													// Google font
													array(
														'name'   => 'Merriweather',
														'family' => 'sans-serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Noto Sans JP",serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
												),
							),
				'garamond' => array(
								'title'  => esc_html__( 'Garamond', 'riff' ),
								'load_fonts' => array(
													// Adobe font
													array(
														'name'   => 'Europe',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
													// Adobe font
													array(
														'name'   => 'Sofia Pro',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Sofia Pro",sans-serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Europe,sans-serif',
													),
												),
							),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'riff_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'riff_skin_setup_schemes', 1 );
	function riff_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		riff_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'riff' ),
					'description' => esc_html__( 'Colors of the main content area', 'riff' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'riff' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'riff' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'riff' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'riff' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'riff' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'riff' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'riff' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'riff' ),
				),
			)
		);

		riff_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'riff' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'riff' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'riff' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'riff' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'riff' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'riff' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'riff' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'riff' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'riff' ),
					'description' => esc_html__( 'Color of the text inside this block', 'riff' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'riff' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'riff' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'riff' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'riff' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'riff' ),
					'description' => esc_html__( 'Color of the links inside this block', 'riff' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'riff' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'riff' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'riff' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'riff' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'riff' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'riff' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'riff' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'riff' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'riff' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'riff' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'riff' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#EBF3F4',
					'bd_color'         => '#D0D5D5',

					// Text and links colors
					'text'             => '#6D7373',
					'text_light'       => '#868B8B',
					'text_dark'        => '#030606',
					'text_link'        => '#D22C39',
					'text_hover'       => '#A71D28',
					'text_link2'       => '#871ABB',
					'text_hover2'      => '#5F0D85',
					'text_link3'       => '#90DA9E',
					'text_hover3'      => '#80C28C',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#DCE5E5',
					'alter_bd_color'   => '#D0D5D5',
					'alter_bd_hover'   => '#BEC2C2',
					'alter_text'       => '#6D7373',
					'alter_light'      => '#868B8B',
					'alter_dark'       => '#030606',
					'alter_link'       => '#D22C39',
					'alter_hover'      => '#A71D28',
					'alter_link2'      => '#871ABB',
					'alter_hover2'     => '#5F0D85',
					'alter_link3'      => '#90DA9E',
					'alter_hover3'     => '#80C28C',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#060B0B',
					'extra_bg_hover'   => '#252E2E',
					'extra_bd_color'   => '#3D4545',
					'extra_bd_hover'   => '#555C5C',
					'extra_text'       => '#CED0D0',
					'extra_light'      => '#9EA2A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#D22C39',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D0D5D5',
					'input_bd_hover'   => '#BEC2C2',
					'input_text'       => '#6D7373',
					'input_light'      => '#868B8B',
					'input_dark'       => '#030606',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#030606',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#EFE8CE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'riff' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#0D1717',
					'bd_color'         => '#3D4545',
					
					// Text and links colors
					'text'             => '#CED0D0',
					'text_light'       => '#9EA2A2',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#D22C39',
					'text_hover'       => '#A71D28',
					'text_link2'       => '#871ABB',
					'text_hover2'      => '#5F0D85',
					'text_link3'       => '#90DA9E',
					'text_hover3'      => '#80C28C',
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#142222',
					'alter_bg_hover'   => '#252E2E',
					'alter_bd_color'   => '#3D4545',
					'alter_bd_hover'   => '#555C5C',
					'alter_text'       => '#CED0D0',
					'alter_light'      => '#9EA2A2',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#D22C39',
					'alter_hover'      => '#A71D28',
					'alter_link2'      => '#871ABB',
					'alter_hover2'     => '#5F0D85',
					'alter_link3'      => '#90DA9E',
					'alter_hover3'     => '#80C28C',
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#060B0B',
					'extra_bg_hover'   => '#252E2E',
					'extra_bd_color'   => '#3D4545',
					'extra_bd_hover'   => '#555C5C',
					'extra_text'       => '#CED0D0',
					'extra_light'      => '#9EA2A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#D22C39',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#3D4545',
					'input_bd_hover'   => '#555C5C',
					'input_text'       => '#CED0D0',
					'input_light'      => '#9EA2A2',
					'input_dark'       => '#FFFEFE',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFEFE',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1F1D1C',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#1F1D1C',
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'light'
			'light' => array(
				'title'    => esc_html__( 'Light', 'riff' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#D0D5D5',

					// Text and links colors
					'text'             => '#6D7373',
					'text_light'       => '#868B8B',
					'text_dark'        => '#030606',
					'text_link'        => '#D22C39',
					'text_hover'       => '#A71D28',
					'text_link2'       => '#871ABB',
					'text_hover2'      => '#5F0D85',
					'text_link3'       => '#90DA9E',
					'text_hover3'      => '#80C28C',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#EBF3F4',
					'alter_bg_hover'   => '#DCE5E5',
					'alter_bd_color'   => '#D0D5D5',
					'alter_bd_hover'   => '#BEC2C2',
					'alter_text'       => '#6D7373',
					'alter_light'      => '#868B8B',
					'alter_dark'       => '#030606',
					'alter_link'       => '#D22C39',
					'alter_hover'      => '#A71D28',
					'alter_link2'      => '#871ABB',
					'alter_hover2'     => '#5F0D85',
					'alter_link3'      => '#90DA9E',
					'alter_hover3'     => '#80C28C',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#060B0B',
					'extra_bg_hover'   => '#252E2E',
					'extra_bd_color'   => '#3D4545',
					'extra_bd_hover'   => '#555C5C',
					'extra_text'       => '#CED0D0',
					'extra_light'      => '#9EA2A2',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#D22C39',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D0D5D5',
					'input_bd_hover'   => '#BEC2C2',
					'input_text'       => '#6D7373',
					'input_light'      => '#868B8B',
					'input_dark'       => '#030606',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#030606',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#EFE8CE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'violet'
			'violet' => array(
				'title'    => esc_html__( 'Violet', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#E4E5EE',
					'bd_color'         => '#D0D0D5',
					
					// Text and links colors
					'text'             => '#6D6D73',
					'text_light'       => '#86878B',
					'text_dark'        => '#030306',
					'text_link'        => '#6842FF',
					'text_hover'       => '#532DED',
					'text_link2'       => '#EB3355',
					'text_hover2'      => '#D91F42',
					'text_link3'       => '#2DE589',
					'text_hover3'      => '#28CC7A',
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#DCDDE5',
					'alter_bd_color'   => '#D0D0D5',
					'alter_bd_hover'   => '#BEBEC2',
					'alter_text'       => '#6D6D73',
					'alter_light'      => '#86878B',
					'alter_dark'       => '#030306',
					'alter_link'       => '#6842FF',
					'alter_hover'      => '#532DED',
					'alter_link2'      => '#EB3355',
					'alter_hover2'     => '#D91F42',
					'alter_link3'      => '#2DE589',
					'alter_hover3'     => '#28CC7A',
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#252735',
					'extra_bg_hover'   => '#212228',
					'extra_bd_color'   => '#3A3A40',
					'extra_bd_hover'   => '#525358',
					'extra_text'       => '#CDCECF',
					'extra_light'      => '#B5B5B7',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#6842FF',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D0D0D5',
					'input_bd_hover'   => '#BEBEC2',
					'input_text'       => '#6D6D73',
					'input_light'      => '#86878B',
					'input_dark'       => '#030306',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#030306',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'violet_dark'
			'violet_dark'    => array(
				'title'    => esc_html__( 'Violet Dark', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#090A11',
					'bd_color'         => '#3A3A40',
					
					// Text and links colors
					'text'             => '#CDCECF',
					'text_light'       => '#B5B5B7',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#6842FF',
					'text_hover'       => '#532DED',
					'text_link2'       => '#EB3355',
					'text_hover2'      => '#D91F42',
					'text_link3'       => '#2DE589',
					'text_hover3'      => '#28CC7A',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#111322',
					'alter_bg_hover'   => '#212228',
					'alter_bd_color'   => '#3A3A40',
					'alter_bd_hover'   => '#525358',
					'alter_text'       => '#CDCECF',
					'alter_light'      => '#B5B5B7',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#6842FF',
					'alter_hover'      => '#532DED',
					'alter_link2'      => '#EB3355',
					'alter_hover2'     => '#D91F42',
					'alter_link3'      => '#2DE589',
					'alter_hover3'     => '#28CC7A',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#252735',
					'extra_bg_hover'   => '#212228',
					'extra_bd_color'   => '#3A3A40',
					'extra_bd_hover'   => '#525358',
					'extra_text'       => '#CDCECF',
					'extra_light'      => '#B5B5B7',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#6842FF',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#3A3A40',
					'input_bd_hover'   => '#525358',
					'input_text'       => '#CDCECF',
					'input_light'      => '#B5B5B7',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#F9F9F9', //
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1F242E', //
					'inverse_link'     => '#FFFEFE', //
					'inverse_hover'    => '#1F242E', //

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'violet_light'
			'violet_light' => array(
				'title'    => esc_html__( 'Violet Light', 'riff' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#D0D0D5',

					// Text and links colors
					'text'             => '#6D6D73',
					'text_light'       => '#86878B',
					'text_dark'        => '#030306',
					'text_link'        => '#6842FF',
					'text_hover'       => '#532DED',
					'text_link2'       => '#EB3355',
					'text_hover2'      => '#D91F42',
					'text_link3'       => '#2DE589',
					'text_hover3'      => '#28CC7A',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#E4E5EE',
					'alter_bg_hover'   => '#ffffff',
					'alter_bd_color'   => '#D0D0D5',
					'alter_bd_hover'   => '#BEBEC2',
					'alter_text'       => '#6D6D73',
					'alter_light'      => '#86878B',
					'alter_dark'       => '#030306',
					'alter_link'       => '#6842FF',
					'alter_hover'      => '#532DED',
					'alter_link2'      => '#EB3355',
					'alter_hover2'     => '#D91F42',
					'alter_link3'      => '#2DE589',
					'alter_hover3'     => '#28CC7A',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#252735',
					'extra_bg_hover'   => '#212228',
					'extra_bd_color'   => '#3A3A40',
					'extra_bd_hover'   => '#525358',
					'extra_text'       => '#CDCECF',
					'extra_light'      => '#B5B5B7',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#6842FF',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D0D0D5',
					'input_bd_hover'   => '#BEBEC2',
					'input_text'       => '#6D6D73',
					'input_light'      => '#86878B',
					'input_dark'       => '#030306',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#030306',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'scarlet'
			'scarlet' => array(
				'title'    => esc_html__( 'Scarlet', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#F6F9F9',
					'bd_color'         => '#DDE7E6',
					
					// Text and links colors
					'text'             => '#5D5B5B',
					'text_light'       => '#807B7B',
					'text_dark'        => '#17130E',
					'text_link'        => '#B40000',
					'text_hover'       => '#8D0000',
					'text_link2'       => '#007D7D',
					'text_hover2'      => '#006F6F',
					'text_link3'       => '#00A700',
					'text_hover3'      => '#1F7D1F',
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#EAEEEE',
					'alter_bd_color'   => '#DDE7E6',
					'alter_bd_hover'   => '#D1DBDA',
					'alter_text'       => '#5D5B5B',
					'alter_light'      => '#807B7B',
					'alter_dark'       => '#17130E',
					'alter_link'       => '#B40000',
					'alter_hover'      => '#8D0000',
					'alter_link2'      => '#007D7D',
					'alter_hover2'     => '#006F6F',
					'alter_link3'      => '#00A700',
					'alter_hover3'     => '#1F7D1F',
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1D1E22',
					'extra_bg_hover'   => '#37383B',
					'extra_bd_color'   => '#4D4E51',
					'extra_bd_hover'   => '#636467',
					'extra_text'       => '#CCCBC9',
					'extra_light'      => '#A5A19F',
					'extra_dark'       => '#FCF9F9',
					'extra_link'       => '#B40000',
					'extra_hover'      => '#FCF9F9',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DDE7E6',
					'input_bd_hover'   => '#D1DBDA',
					'input_text'       => '#5D5B5B',
					'input_light'      => '#807B7B',
					'input_dark'       => '#17130E',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#17130E',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'scarlet_dark'
			'scarlet_dark'    => array(
				'title'    => esc_html__( 'Scarlet Dark', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#1F2024',
					'bd_color'         => '#4D4E51',
					
					// Text and links colors
					'text'             => '#CCCBC9',
					'text_light'       => '#A5A19F',
					'text_dark'        => '#FCF9F9',
					'text_link'        => '#B40000',
					'text_hover'       => '#8D0000',
					'text_link2'       => '#007D7D',
					'text_hover2'      => '#006F6F',
					'text_link3'       => '#00A700',
					'text_hover3'      => '#1F7D1F',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#28292E',
					'alter_bg_hover'   => '#37383B',
					'alter_bd_color'   => '#4D4E51',
					'alter_bd_hover'   => '#636467',
					'alter_text'       => '#CCCBC9',
					'alter_light'      => '#A5A19F',
					'alter_dark'       => '#FCF9F9',
					'alter_link'       => '#B40000',
					'alter_hover'      => '#8D0000',
					'alter_link2'      => '#007D7D',
					'alter_hover2'     => '#006F6F',
					'alter_link3'      => '#00A700',
					'alter_hover3'     => '#1F7D1F',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1D1E22',
					'extra_bg_hover'   => '#37383B',
					'extra_bd_color'   => '#4D4E51',
					'extra_bd_hover'   => '#636467',
					'extra_text'       => '#CCCBC9',
					'extra_light'      => '#A5A19F',
					'extra_dark'       => '#FCF9F9',
					'extra_link'       => '#B40000',
					'extra_hover'      => '#FCF9F9',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#4D4E51',
					'input_bd_hover'   => '#636467',
					'input_text'       => '#CCCBC9',
					'input_light'      => '#A5A19F',
					'input_dark'       => '#FCF9F9',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#F9F9F9', //
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1F242E', //
					'inverse_link'     => '#FFFEFE', //
					'inverse_hover'    => '#1F242E', //

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'scarlet_light'
			'scarlet_light' => array(
				'title'    => esc_html__( 'Scarlet Light', 'riff' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#DDE7E6',

					// Text and links colors
					'text'             => '#5D5B5B',
					'text_light'       => '#807B7B',
					'text_dark'        => '#17130E',
					'text_link'        => '#B40000',
					'text_hover'       => '#8D0000',
					'text_link2'       => '#007D7D',
					'text_hover2'      => '#006F6F',
					'text_link3'       => '#00A700',
					'text_hover3'      => '#1F7D1F',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F6F9F9',
					'alter_bg_hover'   => '#ffffff',
					'alter_bd_color'   => '#DDE7E6',
					'alter_bd_hover'   => '#D1DBDA',
					'alter_text'       => '#5D5B5B',
					'alter_light'      => '#807B7B',
					'alter_dark'       => '#17130E',
					'alter_link'       => '#B40000',
					'alter_hover'      => '#8D0000',
					'alter_link2'      => '#007D7D',
					'alter_hover2'     => '#006F6F',
					'alter_link3'      => '#00A700',
					'alter_hover3'     => '#1F7D1F',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1D1E22',
					'extra_bg_hover'   => '#37383B',
					'extra_bd_color'   => '#4D4E51',
					'extra_bd_hover'   => '#636467',
					'extra_text'       => '#CCCBC9',
					'extra_light'      => '#A5A19F',
					'extra_dark'       => '#FCF9F9',
					'extra_link'       => '#B40000',
					'extra_hover'      => '#FCF9F9',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DDE7E6',
					'input_bd_hover'   => '#D1DBDA',
					'input_text'       => '#5D5B5B',
					'input_light'      => '#807B7B',
					'input_dark'       => '#17130E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#17130E',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'band'
			'band' => array(
				'title'    => esc_html__( 'Band', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#F5F5F5',
					'bd_color'         => '#E3E3E3',
					
					// Text and links colors
					'text'             => '#777777',
					'text_light'       => '#A6A6A6',
					'text_dark'        => '#170E0E',
					'text_link'        => '#6A4EEF',
					'text_hover'       => '#5D41E3',
					'text_link2'       => '#B02929',
					'text_hover2'      => '#A12020',
					'text_link3'       => '#ECDB34',
					'text_hover3'      => '#D4C52E',
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#F0F0F0',
					'alter_bd_color'   => '#E3E3E3',
					'alter_bd_hover'   => '#C3C3C3',
					'alter_text'       => '#777777',
					'alter_light'      => '#A6A6A6',
					'alter_dark'       => '#170E0E',
					'alter_link'       => '#6A4EEF',
					'alter_hover'      => '#5D41E3',
					'alter_link2'      => '#B02929',
					'alter_hover2'     => '#A12020',
					'alter_link3'      => '#ECDB34',
					'alter_hover3'     => '#D4C52E',
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#141414',
					'extra_bg_hover'   => '#333333',
					'extra_bd_color'   => '#4A4A4A',
					'extra_bd_hover'   => '#606060',
					'extra_text'       => '#BBBBBB',
					'extra_light'      => '#D1D1D1',
					'extra_dark'       => '#FCF9F9',
					'extra_link'       => '#6A4EEF',
					'extra_hover'      => '#FCF9F9',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E3E3E3',
					'input_bd_hover'   => '#C3C3C3',
					'input_text'       => '#777777',
					'input_light'      => '#A6A6A6',
					'input_dark'       => '#170E0E',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#170E0E',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'band_dark'
			'band_dark'    => array(
				'title'    => esc_html__( 'Band Dark', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#1D1D1D',
					'bd_color'         => '#4A4A4A',
					
					// Text and links colors
					'text'             => '#BBBBBB',
					'text_light'       => '#D1D1D1',
					'text_dark'        => '#FCF9F9',
					'text_link'        => '#6A4EEF',
					'text_hover'       => '#5D41E3',
					'text_link2'       => '#B02929',
					'text_hover2'      => '#A12020',
					'text_link3'       => '#ECDB34',
					'text_hover3'      => '#D4C52E',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#262525',
					'alter_bg_hover'   => '#333333',
					'alter_bd_color'   => '#4A4A4A',
					'alter_bd_hover'   => '#606060',
					'alter_text'       => '#BBBBBB',
					'alter_light'      => '#D1D1D1',
					'alter_dark'       => '#FCF9F9',
					'alter_link'       => '#6A4EEF',
					'alter_hover'      => '#5D41E3',
					'alter_link2'      => '#B02929',
					'alter_hover2'     => '#A12020',
					'alter_link3'      => '#ECDB34',
					'alter_hover3'     => '#D4C52E',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#141414',
					'extra_bg_hover'   => '#333333',
					'extra_bd_color'   => '#4A4A4A',
					'extra_bd_hover'   => '#606060',
					'extra_text'       => '#BBBBBB',
					'extra_light'      => '#D1D1D1',
					'extra_dark'       => '#FCF9F9',
					'extra_link'       => '#6A4EEF',
					'extra_hover'      => '#FCF9F9',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#4A4A4A',
					'input_bd_hover'   => '#606060',
					'input_text'       => '#BBBBBB',
					'input_light'      => '#D1D1D1',
					'input_dark'       => '#FCF9F9',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#F9F9F9', //
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1F242E', //
					'inverse_link'     => '#FFFEFE', //
					'inverse_hover'    => '#1F242E', //

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'band_light'
			'band_light' => array(
				'title'    => esc_html__( 'Band Light', 'riff' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#E3E3E3',

					// Text and links colors
					'text'             => '#777777',
					'text_light'       => '#A6A6A6',
					'text_dark'        => '#170E0E',
					'text_link'        => '#6A4EEF',
					'text_hover'       => '#5D41E3',
					'text_link2'       => '#B02929',
					'text_hover2'      => '#A12020',
					'text_link3'       => '#ECDB34',
					'text_hover3'      => '#D4C52E',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F5F5F5',
					'alter_bg_hover'   => '#ffffff',
					'alter_bd_color'   => '#E3E3E3',
					'alter_bd_hover'   => '#C3C3C3',
					'alter_text'       => '#777777',
					'alter_light'      => '#A6A6A6',
					'alter_dark'       => '#170E0E',
					'alter_link'       => '#6A4EEF',
					'alter_hover'      => '#5D41E3',
					'alter_link2'      => '#B02929',
					'alter_hover2'     => '#A12020',
					'alter_link3'      => '#ECDB34',
					'alter_hover3'     => '#D4C52E',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#141414',
					'extra_bg_hover'   => '#333333',
					'extra_bd_color'   => '#4A4A4A',
					'extra_bd_hover'   => '#606060',
					'extra_text'       => '#BBBBBB',
					'extra_light'      => '#D1D1D1',
					'extra_dark'       => '#FCF9F9',
					'extra_link'       => '#6A4EEF',
					'extra_hover'      => '#FCF9F9',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E3E3E3',
					'input_bd_hover'   => '#C3C3C3',
					'input_text'       => '#777777',
					'input_light'      => '#A6A6A6',
					'input_dark'       => '#170E0E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#170E0E',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'sunset'
			'sunset' => array(
				'title'    => esc_html__( 'Sunset', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#F7F8FA',
					'bd_color'         => '#E3E3E3',
					
					// Text and links colors
					'text'             => '#797C7F',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#1F242E',
					'text_link'        => '#D33415',
					'text_hover'       => '#C62B0D',
					'text_link2'       => '#9A74F8',
					'text_hover2'      => '#845BEB',
					'text_link3'       => '#FFA96A',
					'text_hover3'      => '#EF8E46',
					
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#EBEBEB',
					'alter_bd_color'   => '#E3E3E3',
					'alter_bd_hover'   => '#C3C3C3',
					'alter_text'       => '#797C7F',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#1F242E',
					'alter_link'       => '#D33415',
					'alter_hover'      => '#C62B0D',
					'alter_link2'      => '#9A74F8',
					'alter_hover2'     => '#845BEB',
					'alter_link3'      => '#FFA96A',
					'alter_hover3'     => '#EF8E46',
					
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1C212B',
					'extra_bg_hover'   => '#161B24',
					'extra_bd_color'   => '#3C3F47',
					'extra_bd_hover'   => '#53535C',
					'extra_text'       => '#D8D8D8',
					'extra_light'      => '#A59F9F',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#D33415',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',
					
					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E3E3E3',
					'input_bd_hover'   => '#C3C3C3',
					'input_text'       => '#797C7F',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#1F242E',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1F242E',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',
					
					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'sunset_dark'
			'sunset_dark'    => array(
				'title'    => esc_html__( 'Sunset Dark', 'riff' ),
				'internal' => true,
				'colors'   => array(
					
					// Whole block border and background
					'bg_color'         => '#1C1C1C',
					'bd_color'         => '#3C3F47',
					
					// Text and links colors
					'text'             => '#D8D8D8',
					'text_light'       => '#A59F9F',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#D33415',
					'text_hover'       => '#C62B0D',
					'text_link2'       => '#9A74F8',
					'text_hover2'      => '#845BEB',
					'text_link3'       => '#FFA96A',
					'text_hover3'      => '#EF8E46',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#131313',
					'alter_bg_hover'   => '#383D4B',
					'alter_bd_color'   => '#3C3F47',
					'alter_bd_hover'   => '#53535C',
					'alter_text'       => '#D8D8D8',
					'alter_light'      => '#A59F9F',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#D33415',
					'alter_hover'      => '#C62B0D',
					'alter_link2'      => '#9A74F8',
					'alter_hover2'     => '#845BEB',
					'alter_link3'      => '#FFA96A',
					'alter_hover3'     => '#EF8E46',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1C212B',
					'extra_bg_hover'   => '#161B24',
					'extra_bd_color'   => '#3C3F47',
					'extra_bd_hover'   => '#53535C',
					'extra_text'       => '#D8D8D8',
					'extra_light'      => '#A59F9F',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#D33415',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#3C3F47',
					'input_bd_hover'   => '#53535C',
					'input_text'       => '#D8D8D8',
					'input_light'      => '#A59F9F',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#F9F9F9', //
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1F242E', //
					'inverse_link'     => '#FFFEFE', //
					'inverse_hover'    => '#1F242E', //

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'sunset_light'
			'sunset_light' => array(
				'title'    => esc_html__( 'Sunset Light', 'riff' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#E3E3E3',

					// Text and links colors
					'text'             => '#797C7F',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#1F242E',
					'text_link'        => '#D33415',
					'text_hover'       => '#C62B0D',
					'text_link2'       => '#9A74F8',
					'text_hover2'      => '#845BEB',
					'text_link3'       => '#FFA96A',
					'text_hover3'      => '#EF8E46',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F7F8FA',
					'alter_bg_hover'   => '#ffffff',
					'alter_bd_color'   => '#E3E3E3',
					'alter_bd_hover'   => '#C3C3C3',
					'alter_text'       => '#797C7F',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#1F242E',
					'alter_link'       => '#D33415',
					'alter_hover'      => '#C62B0D',
					'alter_link2'      => '#9A74F8',
					'alter_hover2'     => '#845BEB',
					'alter_link3'      => '#FFA96A',
					'alter_hover3'     => '#EF8E46',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1C212B',
					'extra_bg_hover'   => '#161B24',
					'extra_bd_color'   => '#3C3F47',
					'extra_bd_hover'   => '#53535C',
					'extra_text'       => '#D8D8D8',
					'extra_light'      => '#A59F9F',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#D33415',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E3E3E3',
					'input_bd_hover'   => '#C3C3C3',
					'input_text'       => '#797C7F',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#1F242E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1F242E',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#F8F4FF',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
		);
		riff_storage_set( 'schemes', $schemes );
		riff_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> riff_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'riff' ),
		//---> 	'description' => __( 'Description of the new color 1', 'riff' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		riff_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_08' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.8,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
                'alter_dark_02'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.2,
                ),
                'alter_dark_05'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.5,
                ),
                'alter_dark_08'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.8,
                ),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_dark_04'     => array(
					'color' => 'extra_dark',
					'alpha' => 0.4,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
                'text_dark_003'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.03,
                ),
                'text_dark_005'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.05,
                ),
                'text_dark_008'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.08,
                ),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
                'text_dark_03'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.3,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'text_dark_08'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.8,
                ),
                'text_link_007'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.07,
                ),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
                'text_link_03'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.3,
                ),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_05'      => array(
					'color' => 'text_link',
					'alpha' => 0.5,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_007'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.07,
                ),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
                'text_link2_03'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.3,
                ),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
                'text_link3_007'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.07,
                ),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
                'text_link3_03'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.3,
                ),
                'inverse_text_03'      => array(
                    'color' => 'inverse_text',
                    'alpha' => 0.3,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_hover_08'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.8,
                ),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		riff_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		riff_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		riff_storage_set(
			'color_presets', array(
				'autumn' => array(
								'title'  => esc_html__( 'Autumn', 'riff' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	),
												'dark' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	)
												)
							),
				'green' => array(
								'title'  => esc_html__( 'Natural Green', 'riff' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	),
												'dark' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	)
												)
							),
			)
		);
	}
}

// Enqueue extra styles for frontend
if ( ! function_exists( 'riff_clone_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'riff_clone_frontend_scripts', 1350 );
	function riff_clone_frontend_scripts() {
		$riff_url = riff_get_file_url( riff_skins_get_current_skin_dir() . 'extra-styles.css' );
		if ( '' != $riff_url ) {
			wp_enqueue_style( 'riff-extra-skin-' . esc_attr( riff_skins_get_current_skin_name() ), $riff_url, array(), null );
		}
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'riff_clone_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'riff_clone_theme_setup3', 3 );
	function riff_clone_theme_setup3() {
		riff_storage_set_array_after( 'options', 'extra_bg_image', array(
				'extra_bg_image_size'   => array(
					'title'      => esc_html__( 'Extra background image size', 'riff' ),
					'desc'       => wp_kses_data( __( 'Select a size of background-image', 'riff' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'riff' )
					),
					'dependency' => array(
						'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
					),
					'pro_only'   => RIFF_THEME_FREE,
					'std'        => 'cover',
					'options' => array(
						'cover'       => esc_html__( 'Cover', 'riff' ),
						'contain'     => esc_html__( 'Contain', 'riff' ),
						'auto'        => esc_html__( 'Auto', 'riff' ),
					),
					'type'       => 'select'
				),
				'extra_bg_image_repeat' => array(
					'title'      => esc_html__( 'Extra background repeat', 'riff' ),
					'desc'       => wp_kses_data( __( 'Select a repeat of background image', 'riff' ) ),
					"override"   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'riff' )
					),
					'dependency' => array(
						'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
					),
					'pro_only'   => RIFF_THEME_FREE,
					'std'        => '',
					'options'    => array(
						''       => esc_html__( 'No-repeat', 'riff' ),
						'repeat' => esc_html__( 'Repeat', 'riff' ),
					),
					'type'       => 'select'
				),
			)
		);
	}
}

if ( ! function_exists( 'riff_clone_filter_page_wrap_class' ) ) {
	add_action( 'riff_filter_page_wrap_class', 'riff_clone_filter_page_wrap_class' );
	function riff_clone_filter_page_wrap_class( $class ) {
		$extra_bg_image   = riff_get_theme_option( 'extra_bg_image' );
		$extra_bg_size    = riff_get_theme_option( 'extra_bg_image_size' );
		$extra_bg_repeat  = riff_get_theme_option( 'extra_bg_image_repeat' ) === 'repeat' ? ' extra_bg_repeat' : '';
		$body_boxed_style = riff_get_theme_option( 'body_style' ) === 'boxed';
		if ( ! empty( $extra_bg_image ) && ! $body_boxed_style ) {
			$class = $class . ( !empty( $extra_bg_size ) ? ' extra_bg_'.$extra_bg_size : '' ) . $extra_bg_repeat;
		}
		
		return $class;
	}
}


if ( ! function_exists( 'riff_clone_filter_args_featured' ) ) {
	add_filter( 'trx_addons_filter_args_featured', 'riff_clone_filter_args_featured', 10, 3 );
	function riff_clone_filter_args_featured( $args, $mode, $template_args = array() ) {
		if (
			$mode === 'portfolio-default'
			&& ! empty( $template_args['type'] )
			&& $template_args['type'] === 'extra' ) {
			$args['thumb_size'] = riff_get_thumb_size( 'masonry-big' );
		}
		
		return $args;
	}
}

// Override options for CPT - Team
if ( ! function_exists( 'riff_clone_options_get_list_cpt_options' ) ) {
	add_filter('riff_filter_get_list_cpt_options', 'riff_clone_options_get_list_cpt_options', 10, 3);
	function riff_clone_options_get_list_cpt_options( $options, $cpt, $title ) {
		if( 'team' == $cpt ) {
			$options = array_merge(riff_options_get_list_cpt_options_color( $cpt, $title ), $options);
		}
		return $options;
	}
}


// Activation methods
if ( ! function_exists( 'riff_skin_filter_activation_methods2' ) ) {
	add_filter( 'trx_addons_filter_activation_methods', 'riff_skin_filter_activation_methods2', 11, 1 );
	function riff_skin_filter_activation_methods2( $args ) {
		$args['elements_key'] = true;
		return $args;
	}
}