<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RIFF
 * @since RIFF 1.71.0
 */

$riff_template_args = get_query_var( 'riff_template_args' );
if ( ! is_array( $riff_template_args ) ) {
	$riff_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$riff_columns       = 1;

$riff_expanded      = ! riff_sidebar_present() && riff_get_theme_option( 'expand_content' ) == 'expand';

$riff_post_format   = get_post_format();
$riff_post_format   = empty( $riff_post_format ) ? 'standard' : str_replace( 'post-format-', '', $riff_post_format );

if ( is_array( $riff_template_args ) ) {
	$riff_columns    = empty( $riff_template_args['columns'] ) ? 1 : max( 1, $riff_template_args['columns'] );
	$riff_blog_style = array( $riff_template_args['type'], $riff_columns );
	if ( ! empty( $riff_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $riff_columns > 1 ) {
	    $riff_columns_class = riff_get_column_class( 1, $riff_columns, ! empty( $riff_template_args['columns_tablet']) ? $riff_template_args['columns_tablet'] : '', ! empty($riff_template_args['columns_mobile']) ? $riff_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $riff_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $riff_post_format ) );
	riff_add_blog_animation( $riff_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$riff_hover      = ! empty( $riff_template_args['hover'] ) && ! riff_is_inherit( $riff_template_args['hover'] )
							? $riff_template_args['hover']
							: riff_get_theme_option( 'image_hover' );
	$riff_components = ! empty( $riff_template_args['meta_parts'] )
							? ( is_array( $riff_template_args['meta_parts'] )
								? $riff_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $riff_template_args['meta_parts'] ) )
								)
							: riff_array_get_keys_by_value( riff_get_theme_option( 'meta_parts' ) );
	riff_show_post_featured( apply_filters( 'riff_filter_args_featured',
		array(
			'no_links'   => ! empty( $riff_template_args['no_links'] ),
			'hover'      => $riff_hover,
			'meta_parts' => $riff_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $riff_template_args['thumb_size'] )
								? $riff_template_args['thumb_size']
								: riff_get_thumb_size( 
								in_array( $riff_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( riff_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $riff_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$riff_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$riff_show_title = get_the_title() != '';
		$riff_show_meta  = count( $riff_components ) > 0 && ! in_array( $riff_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $riff_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'riff_filter_show_blog_categories', $riff_show_meta && in_array( 'categories', $riff_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'riff_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						riff_show_post_meta( apply_filters(
															'riff_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $riff_hover, 1
															)
											);
						?>
					</div>
					<?php
					$riff_components = riff_array_delete_by_value( $riff_components, 'categories' );
					do_action( 'riff_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'riff_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'riff_action_before_post_title' );
					if ( empty( $riff_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'riff_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $riff_template_args['excerpt_length'] ) && ! in_array( $riff_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$riff_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'riff_filter_show_blog_excerpt', empty( $riff_template_args['hide_excerpt'] ) && riff_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				riff_show_post_content( $riff_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'riff_filter_show_blog_meta', $riff_show_meta, $riff_components, 'band' ) ) {
			if ( count( $riff_components ) > 0 ) {
				do_action( 'riff_action_before_post_meta' );
				riff_show_post_meta(
					apply_filters(
						'riff_filter_post_meta_args', array(
							'components' => join( ',', $riff_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'riff_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'riff_filter_show_blog_readmore', ! $riff_show_title || ! empty( $riff_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $riff_template_args['no_links'] ) ) {
				do_action( 'riff_action_before_post_readmore' );
				riff_show_post_more_link( $riff_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'riff_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $riff_template_args ) ) {
	if ( ! empty( $riff_template_args['slider'] ) || $riff_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
