<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RIFF
 * @since RIFF 1.0
 */

$riff_template_args = get_query_var( 'riff_template_args' );

if ( is_array( $riff_template_args ) ) {
	$riff_columns    = empty( $riff_template_args['columns'] ) ? 2 : max( 1, $riff_template_args['columns'] );
	$riff_blog_style = array( $riff_template_args['type'], $riff_columns );
    $riff_columns_class = riff_get_column_class( 1, $riff_columns, ! empty( $riff_template_args['columns_tablet']) ? $riff_template_args['columns_tablet'] : '', ! empty($riff_template_args['columns_mobile']) ? $riff_template_args['columns_mobile'] : '' );
} else {
	$riff_template_args = array();
	$riff_blog_style = explode( '_', riff_get_theme_option( 'blog_style' ) );
	$riff_columns    = empty( $riff_blog_style[1] ) ? 2 : max( 1, $riff_blog_style[1] );
    $riff_columns_class = riff_get_column_class( 1, $riff_columns );
}
$riff_expanded   = ! riff_sidebar_present() && riff_get_theme_option( 'expand_content' ) == 'expand';

$riff_post_format = get_post_format();
$riff_post_format = empty( $riff_post_format ) ? 'standard' : str_replace( 'post-format-', '', $riff_post_format );

?><div class="<?php
	if ( ! empty( $riff_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( riff_is_blog_style_use_masonry( $riff_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $riff_columns ) : esc_attr( $riff_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $riff_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $riff_columns )
				. ' post_layout_' . esc_attr( $riff_blog_style[0] )
				. ' post_layout_' . esc_attr( $riff_blog_style[0] ) . '_' . esc_attr( $riff_columns )
	);
	riff_add_blog_animation( $riff_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$riff_hover      = ! empty( $riff_template_args['hover'] ) && ! riff_is_inherit( $riff_template_args['hover'] )
							? $riff_template_args['hover']
							: riff_get_theme_option( 'image_hover' );

	$riff_components = ! empty( $riff_template_args['meta_parts'] )
							? ( is_array( $riff_template_args['meta_parts'] )
								? $riff_template_args['meta_parts']
								: explode( ',', $riff_template_args['meta_parts'] )
								)
							: riff_array_get_keys_by_value( riff_get_theme_option( 'meta_parts' ) );

	riff_show_post_featured( apply_filters( 'riff_filter_args_featured',
		array(
			'thumb_size' => ! empty( $riff_template_args['thumb_size'] )
				? $riff_template_args['thumb_size']
				: riff_get_thumb_size(
					'classic' == $riff_blog_style[0]
						? ( strpos( riff_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $riff_columns > 2 ? 'big' : 'huge' )
								: ( $riff_columns > 2
									? ( $riff_expanded ? 'square' : 'square' )
									: ($riff_columns > 1 ? 'square' : ( $riff_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( riff_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $riff_columns > 2 ? 'masonry-big' : 'full' )
								: ($riff_columns === 1 ? ( $riff_expanded ? 'huge' : 'big' ) : ( $riff_columns <= 2 && $riff_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $riff_hover,
			'meta_parts' => $riff_components,
			'no_links'   => ! empty( $riff_template_args['no_links'] ),
        ),
        'content-classic',
        $riff_template_args
    ) );

	// Title and post meta
	$riff_show_title = get_the_title() != '';
	$riff_show_meta  = count( $riff_components ) > 0 && ! in_array( $riff_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $riff_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'riff_filter_show_blog_meta', $riff_show_meta, $riff_components, 'classic' ) ) {
				if ( count( $riff_components ) > 0 ) {
					do_action( 'riff_action_before_post_meta' );
					riff_show_post_meta(
						apply_filters(
							'riff_filter_post_meta_args', array(
							'components' => join( ',', $riff_components ),
							'seo'        => false,
							'echo'       => true,
						), $riff_blog_style[0], $riff_columns
						)
					);
					do_action( 'riff_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'riff_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'riff_action_before_post_title' );
				if ( empty( $riff_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'riff_action_after_post_title' );
			}

			if( !in_array( $riff_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'riff_filter_show_blog_readmore', ! $riff_show_title || ! empty( $riff_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $riff_template_args['no_links'] ) ) {
						do_action( 'riff_action_before_post_readmore' );
						riff_show_post_more_link( $riff_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'riff_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $riff_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('riff_filter_show_blog_excerpt', empty($riff_template_args['hide_excerpt']) && riff_get_theme_option('excerpt_length') > 0, 'classic')) {
			riff_show_post_content($riff_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $riff_template_args['more_button'] )) {
			if ( empty( $riff_template_args['no_links'] ) ) {
				do_action( 'riff_action_before_post_readmore' );
				riff_show_post_more_link( $riff_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'riff_action_after_post_readmore' );
			}
		}
		$riff_content = ob_get_contents();
		ob_end_clean();
		riff_show_layout($riff_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
