<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RIFF
 * @since RIFF 1.0.50
 */

$riff_template_args = get_query_var( 'riff_template_args' );
if ( is_array( $riff_template_args ) ) {
	$riff_columns    = empty( $riff_template_args['columns'] ) ? 2 : max( 1, $riff_template_args['columns'] );
	$riff_blog_style = array( $riff_template_args['type'], $riff_columns );
} else {
	$riff_template_args = array();
	$riff_blog_style = explode( '_', riff_get_theme_option( 'blog_style' ) );
	$riff_columns    = empty( $riff_blog_style[1] ) ? 2 : max( 1, $riff_blog_style[1] );
}
$riff_blog_id       = riff_get_custom_blog_id( join( '_', $riff_blog_style ) );
$riff_blog_style[0] = str_replace( 'blog-custom-', '', $riff_blog_style[0] );
$riff_expanded      = ! riff_sidebar_present() && riff_get_theme_option( 'expand_content' ) == 'expand';
$riff_components    = ! empty( $riff_template_args['meta_parts'] )
							? ( is_array( $riff_template_args['meta_parts'] )
								? join( ',', $riff_template_args['meta_parts'] )
								: $riff_template_args['meta_parts']
								)
							: riff_array_get_keys_by_value( riff_get_theme_option( 'meta_parts' ) );
$riff_post_format   = get_post_format();
$riff_post_format   = empty( $riff_post_format ) ? 'standard' : str_replace( 'post-format-', '', $riff_post_format );

$riff_blog_meta     = riff_get_custom_layout_meta( $riff_blog_id );
$riff_custom_style  = ! empty( $riff_blog_meta['scripts_required'] ) ? $riff_blog_meta['scripts_required'] : 'none';

if ( ! empty( $riff_template_args['slider'] ) || $riff_columns > 1 || ! riff_is_off( $riff_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $riff_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( riff_is_off( $riff_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $riff_custom_style ) ) . "-1_{$riff_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $riff_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $riff_columns )
					. ' post_layout_' . esc_attr( $riff_blog_style[0] )
					. ' post_layout_' . esc_attr( $riff_blog_style[0] ) . '_' . esc_attr( $riff_columns )
					. ( ! riff_is_off( $riff_custom_style )
						? ' post_layout_' . esc_attr( $riff_custom_style )
							. ' post_layout_' . esc_attr( $riff_custom_style ) . '_' . esc_attr( $riff_columns )
						: ''
						)
		);
	riff_add_blog_animation( $riff_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'riff_action_show_layout', $riff_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $riff_template_args['slider'] ) || $riff_columns > 1 || ! riff_is_off( $riff_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
