<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package RIFF
 * @since RIFF 1.0
 */

$riff_columns     = max( 1, min( 3, count( get_option( 'sticky_posts' ) ) ) );
$riff_post_format = get_post_format();
$riff_post_format = empty( $riff_post_format ) ? 'standard' : str_replace( 'post-format-', '', $riff_post_format );

?><div class="column-1_<?php echo esc_attr( $riff_columns ); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class( 'post_item post_layout_sticky post_format_' . esc_attr( $riff_post_format ) );
	riff_add_blog_animation( $riff_template_args );
	?>
>

	<?php
	if ( is_sticky() && is_home() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	riff_show_post_featured(
		array(
			'thumb_size' => riff_get_thumb_size( 1 == $riff_columns ? 'big' : ( 2 == $riff_columns ? 'med' : 'avatar' ) ),
		)
	);

	if ( ! in_array( $riff_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h5 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			riff_show_post_meta( apply_filters( 'riff_filter_post_meta_args', array(), 'sticky', $riff_columns ) );
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div><?php

// div.column-1_X is a inline-block and new lines and spaces after it are forbidden
