<?php
/**
 * The template to display the site logo in the footer
 *
 * @package RIFF
 * @since RIFF 1.0.10
 */

// Logo
if ( riff_is_on( riff_get_theme_option( 'logo_in_footer' ) ) ) {
	$riff_logo_image = riff_get_logo_image( 'footer' );
	$riff_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $riff_logo_image['logo'] ) || ! empty( $riff_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $riff_logo_image['logo'] ) ) {
					$riff_attr = riff_getimagesize( $riff_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $riff_logo_image['logo'] ) . '"'
								. ( ! empty( $riff_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $riff_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'riff' ) . '"'
								. ( ! empty( $riff_attr[3] ) ? ' ' . wp_kses_data( $riff_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $riff_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $riff_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
