<?php
/**
 * The template to display default site header
 *
 * @package RIFF
 * @since RIFF 1.0
 */

$riff_header_css   = '';
$riff_header_image = get_header_image();
$riff_header_video = riff_get_header_video();
if ( ! empty( $riff_header_image ) && riff_trx_addons_featured_image_override( is_singular() || riff_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$riff_header_image = riff_get_current_mode_image( $riff_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $riff_header_image ) || ! empty( $riff_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $riff_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $riff_header_image ) {
		echo ' ' . esc_attr( riff_add_inline_css_class( 'background-image: url(' . esc_url( $riff_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( riff_is_on( riff_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight riff-full-height';
	}
	$riff_header_scheme = riff_get_theme_option( 'header_scheme' );
	if ( ! empty( $riff_header_scheme ) && ! riff_is_inherit( $riff_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $riff_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $riff_header_video ) ) {
		get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( riff_is_on( riff_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
