<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package RIFF
 * @since RIFF 1.0
 */

							do_action( 'riff_action_page_content_end_text' );
							
							// Widgets area below the content
							riff_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'riff_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'riff_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'riff_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'riff_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$riff_body_style = riff_get_theme_option( 'body_style' );
					$riff_widgets_name = riff_get_theme_option( 'widgets_below_page', 'hide' );
					$riff_show_widgets = ! riff_is_off( $riff_widgets_name ) && is_active_sidebar( $riff_widgets_name );
					$riff_show_related = riff_is_single() && riff_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $riff_show_widgets || $riff_show_related ) {
						if ( 'fullscreen' != $riff_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $riff_show_related ) {
							do_action( 'riff_action_related_posts' );
						}

						// Widgets area below page content
						if ( $riff_show_widgets ) {
							riff_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $riff_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'riff_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'riff_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! riff_is_singular( 'post' ) && ! riff_is_singular( 'attachment' ) ) || ! in_array ( riff_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<span id="footer_skip_link_anchor" class="riff_skip_link_anchor"></span>
				<?php

				do_action( 'riff_action_before_footer' );

				// Footer
				$riff_footer_type = riff_get_theme_option( 'footer_type' );
				if ( 'custom' == $riff_footer_type && ! riff_is_layouts_available() ) {
					$riff_footer_type = 'default';
				}
				get_template_part( apply_filters( 'riff_filter_get_template_part', "templates/footer-" . sanitize_file_name( $riff_footer_type ) ) );

				do_action( 'riff_action_after_footer' );

			}
			?>

			<?php do_action( 'riff_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'riff_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'riff_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>