<?php
$riff_woocommerce_sc = riff_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $riff_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$riff_scheme = riff_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $riff_scheme ) && ! riff_is_inherit( $riff_scheme ) ) {
			echo ' scheme_' . esc_attr( $riff_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( riff_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( riff_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$riff_css      = '';
			$riff_bg_image = riff_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $riff_bg_image ) ) {
				$riff_css .= 'background-image: url(' . esc_url( riff_get_attachment_url( $riff_bg_image ) ) . ');';
			}
			if ( ! empty( $riff_css ) ) {
				echo ' style="' . esc_attr( $riff_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$riff_anchor_icon = riff_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$riff_anchor_text = riff_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $riff_anchor_icon ) || ! empty( $riff_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $riff_anchor_icon ) ? ' icon="' . esc_attr( $riff_anchor_icon ) . '"' : '' )
											. ( ! empty( $riff_anchor_text ) ? ' title="' . esc_attr( $riff_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( riff_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' riff-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$riff_css      = '';
				$riff_bg_mask  = riff_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$riff_bg_color_type = riff_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $riff_bg_color_type ) {
					$riff_bg_color = riff_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $riff_bg_color_type ) {
					$riff_bg_color = riff_get_scheme_color( 'bg_color', $riff_scheme );
				} else {
					$riff_bg_color = '';
				}
				if ( ! empty( $riff_bg_color ) && $riff_bg_mask > 0 ) {
					$riff_css .= 'background-color: ' . esc_attr(
						1 == $riff_bg_mask ? $riff_bg_color : riff_hex2rgba( $riff_bg_color, $riff_bg_mask )
					) . ';';
				}
				if ( ! empty( $riff_css ) ) {
					echo ' style="' . esc_attr( $riff_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$riff_caption     = riff_get_theme_option( 'front_page_woocommerce_caption' );
				$riff_description = riff_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $riff_caption ) || ! empty( $riff_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $riff_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $riff_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $riff_caption, 'riff_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $riff_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $riff_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $riff_description ), 'riff_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $riff_woocommerce_sc ) {
						$riff_woocommerce_sc_ids      = riff_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$riff_woocommerce_sc_per_page = count( explode( ',', $riff_woocommerce_sc_ids ) );
					} else {
						$riff_woocommerce_sc_per_page = max( 1, (int) riff_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$riff_woocommerce_sc_columns = max( 1, min( $riff_woocommerce_sc_per_page, (int) riff_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$riff_woocommerce_sc}"
										. ( 'products' == $riff_woocommerce_sc
												? ' ids="' . esc_attr( $riff_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $riff_woocommerce_sc
												? ' category="' . esc_attr( riff_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $riff_woocommerce_sc
												? ' orderby="' . esc_attr( riff_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( riff_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $riff_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $riff_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
