<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package RIFF
 * @since RIFF 1.0
 */

$riff_template = apply_filters( 'riff_filter_get_template_part', riff_blog_archive_get_template() );

if ( ! empty( $riff_template ) && 'index' != $riff_template ) {

	get_template_part( $riff_template );

} else {

	riff_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$riff_stickies   = is_home()
								|| ( in_array( riff_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) riff_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$riff_post_type  = riff_get_theme_option( 'post_type' );
		$riff_args       = array(
								'blog_style'     => riff_get_theme_option( 'blog_style' ),
								'post_type'      => $riff_post_type,
								'taxonomy'       => riff_get_post_type_taxonomy( $riff_post_type ),
								'parent_cat'     => riff_get_theme_option( 'parent_cat' ),
								'posts_per_page' => riff_get_theme_option( 'posts_per_page' ),
								'sticky'         => riff_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $riff_stickies )
															&& count( $riff_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		riff_blog_archive_start();

		do_action( 'riff_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'riff_action_before_page_author' );
			get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'riff_action_after_page_author' );
		}

		if ( riff_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'riff_action_before_page_filters' );
			riff_show_filters( $riff_args );
			do_action( 'riff_action_after_page_filters' );
		} else {
			do_action( 'riff_action_before_page_posts' );
			riff_show_posts( array_merge( $riff_args, array( 'cat' => $riff_args['parent_cat'] ) ) );
			do_action( 'riff_action_after_page_posts' );
		}

		do_action( 'riff_action_blog_archive_end' );

		riff_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
