<?php
/**
 * Required plugins
 *
 * @package RIFF
 * @since RIFF 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
if ( ! function_exists( 'riff_skin_required_plugins' ) ) {
	add_action( 'after_setup_theme', 'riff_skin_required_plugins', -1 );
	/**
	 * Create the list of required plugins for the skin/theme.
	 * Priority -1 is used to create the list of plugins before the rest skin/theme actions.
	 * 
	 * @hooked 'after_setup_theme', -1
	 */
	function riff_skin_required_plugins() {
		$riff_theme_required_plugins_groups = array(
		'core'          => esc_html__( 'Core', 'riff' ),
		'page_builders' => esc_html__( 'Page Builders', 'riff' ),
		'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'riff' ),
		'socials'       => esc_html__( 'Socials and Communities', 'riff' ),
		'events'        => esc_html__( 'Events and Appointments', 'riff' ),
		'content'       => esc_html__( 'Content', 'riff' ),
		'other'         => esc_html__( 'Other', 'riff' ),
		);
		$riff_theme_required_plugins = array(
			'trx_addons'                 => array(
				'title'       => esc_html__( 'ThemeREX Addons', 'riff' ),
				'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'riff' ),
				'required'    => true,
				'logo'        => 'trx_addons.png',
				'group'       => $riff_theme_required_plugins_groups['core'],
			),
			'elementor'                  => array(
				'title'       => esc_html__( 'Elementor', 'riff' ),
				'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'riff' ),
				'required'    => false,
				'logo'        => 'elementor.png',
				'group'       => $riff_theme_required_plugins_groups['page_builders'],
			),
			'gutenberg'                  => array(
				'title'       => esc_html__( 'Gutenberg', 'riff' ),
				'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'riff' ),
				'required'    => false,
				'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'gutenberg.png',
				'group'       => $riff_theme_required_plugins_groups['page_builders'],
			),
			'js_composer'                => array(
				'title'       => esc_html__( 'WPBakery PageBuilder', 'riff' ),
				'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'riff' ),
				'required'    => false,
				'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'js_composer.jpg',
				'group'       => $riff_theme_required_plugins_groups['page_builders'],
			),
			'woocommerce'                => array(
				'title'       => esc_html__( 'WooCommerce', 'riff' ),
				'description' => esc_html__( "Connect the store to your website and start selling now", 'riff' ),
				'required'    => false,
				'install'     => false,
				'logo'        => 'woocommerce.png',
				'group'       => $riff_theme_required_plugins_groups['ecommerce'],
			),
			'elegro-payment'             => array(
				'title'       => esc_html__( 'Elegro Crypto Payment', 'riff' ),
				'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'riff' ),
				'required'    => false,
				'install'     => false, // TRX_addons has marked the "Elegro Crypto Payment" plugin as obsolete and no longer recommends it for installation, even if it had been previously recommended by the theme
				'logo'        => 'elegro-payment.png',
				'group'       => $riff_theme_required_plugins_groups['ecommerce'],
			),
			'instagram-feed'             => array(
				'title'       => esc_html__( 'Instagram Feed', 'riff' ),
				'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'riff' ),
				'required'    => false,
				'logo'        => 'instagram-feed.png',
				'group'       => $riff_theme_required_plugins_groups['socials'],
			),
			'mailchimp-for-wp'           => array(
				'title'       => esc_html__( 'MailChimp for WP', 'riff' ),
				'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'riff' ),
				'required'    => false,
				'logo'        => 'mailchimp-for-wp.png',
				'group'       => $riff_theme_required_plugins_groups['socials'],
			),
			'booked'                     => array(
				'title'       => esc_html__( 'Booked Appointments', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'booked.png',
				'group'       => $riff_theme_required_plugins_groups['events'],
			),
			'quickcal'                     => array(
				'title'       => esc_html__( 'QuickCal', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'quickcal.png',
				'group'       => $riff_theme_required_plugins_groups['events'],
			),
			'the-events-calendar'        => array(
				'title'       => esc_html__( 'The Events Calendar', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'the-events-calendar.png',
				'group'       => $riff_theme_required_plugins_groups['events'],
			),
			'contact-form-7'             => array(
				'title'       => esc_html__( 'Contact Form 7', 'riff' ),
				'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'riff' ),
				'required'    => false,
				'logo'        => 'contact-form-7.png',
				'group'       => $riff_theme_required_plugins_groups['content'],
			),

			'latepoint'                  => array(
				'title'       => esc_html__( 'LatePoint', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => riff_get_file_url( 'plugins/latepoint/latepoint.png' ),
				'group'       => $riff_theme_required_plugins_groups['events'],
			),
			'advanced-popups'                  => array(
				'title'       => esc_html__( 'Advanced Popups', 'riff' ),
				'description' => '',
				'required'    => false,
				'logo'        => riff_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
				'group'       => $riff_theme_required_plugins_groups['content'],
			),
			'devvn-image-hotspot'                  => array(
				'title'       => esc_html__( 'Image Hotspot by DevVN', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => riff_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
				'group'       => $riff_theme_required_plugins_groups['content'],
			),
			'ti-woocommerce-wishlist'                  => array(
				'title'       => esc_html__( 'TI WooCommerce Wishlist', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => riff_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
				'group'       => $riff_theme_required_plugins_groups['ecommerce'],
			),
			'woo-smart-quick-view'                  => array(
				'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => riff_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
				'group'       => $riff_theme_required_plugins_groups['ecommerce'],
			),
			'twenty20'                  => array(
				'title'       => esc_html__( 'Twenty20 Image Before-After', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => riff_get_file_url( 'plugins/twenty20/twenty20.png' ),
				'group'       => $riff_theme_required_plugins_groups['content'],
			),
			'essential-grid'             => array(
				'title'       => esc_html__( 'Essential Grid', 'riff' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'essential-grid.png',
				'group'       => $riff_theme_required_plugins_groups['content'],
			),
			'revslider'                  => array(
				'title'       => esc_html__( 'Revolution Slider', 'riff' ),
				'description' => '',
				'required'    => false,
				'logo'        => 'revslider.png',
				'group'       => $riff_theme_required_plugins_groups['content'],
			),
			'sitepress-multilingual-cms' => array(
				'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'riff' ),
				'description' => esc_html__( "Allows you to make your website multilingual", 'riff' ),
				'required'    => false,
				'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'sitepress-multilingual-cms.png',
				'group'       => $riff_theme_required_plugins_groups['content'],
			),
			'wp-gdpr-compliance'         => array(
				'title'       => esc_html__( 'Cookie Information', 'riff' ),
				'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'riff' ),
				'required'    => false,
				'install'     => false,
				'logo'        => 'wp-gdpr-compliance.png',
				'group'       => $riff_theme_required_plugins_groups['other'],
			),
			'gdpr-framework'         => array(
				'title'       => esc_html__( 'The GDPR Framework', 'riff' ),
				'description' => esc_html__( "Tools to help make your website GDPR-compliant. Fully documented, extendable and developer-friendly.", 'riff' ),
				'required'    => false,
				'install'     => false,
				'logo'        => 'gdpr-framework.png',
				'group'       => $riff_theme_required_plugins_groups['other'],
			),
			'trx_updater'                => array(
				'title'       => esc_html__( 'ThemeREX Updater', 'riff' ),
				'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'riff' ),
				'required'    => false,
				'logo'        => 'trx_updater.png',
				'group'       => $riff_theme_required_plugins_groups['other'],
			),
		);

		if ( RIFF_THEME_FREE ) {
			unset( $riff_theme_required_plugins['js_composer'] );
			unset( $riff_theme_required_plugins['booked'] );
			unset( $riff_theme_required_plugins['quickcal'] );
			unset( $riff_theme_required_plugins['the-events-calendar'] );
			unset( $riff_theme_required_plugins['calculated-fields-form'] );
			unset( $riff_theme_required_plugins['essential-grid'] );
			unset( $riff_theme_required_plugins['revslider'] );
			unset( $riff_theme_required_plugins['sitepress-multilingual-cms'] );
			unset( $riff_theme_required_plugins['trx_updater'] );
			unset( $riff_theme_required_plugins['trx_popup'] );
		}

		// Add plugins list to the global storage
		riff_storage_set( 'required_plugins', $riff_theme_required_plugins );
	}
}
