<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package RIFF
 * @since RIFF 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( riff_is_on( riff_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( riff_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( riff_is_on( riff_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$riff_mult = riff_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $riff_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( riff_is_on( riff_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$riff_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $riff_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( riff_is_on( riff_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $riff_author_description ), 'riff_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$riff_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );
			if ( $riff_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $riff_posts_total, 'riff' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $riff_posts_total ) . '</span>'
								 		),
							'riff_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'riff' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'riff_action_user_meta', 'author-page' );
			$riff_socials = ob_get_contents();
			ob_end_clean();
			riff_show_layout( $riff_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'riff' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
