<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package RIFF
 * @since RIFF 1.0
 */

$riff_template_args = get_query_var( 'riff_template_args' );
if ( is_array( $riff_template_args ) ) {
	$riff_columns    = empty( $riff_template_args['columns'] ) ? 2 : max( 1, $riff_template_args['columns'] );
	$riff_blog_style = array( $riff_template_args['type'], $riff_columns );
    $riff_columns_class = riff_get_column_class( 1, $riff_columns, ! empty( $riff_template_args['columns_tablet']) ? $riff_template_args['columns_tablet'] : '', ! empty($riff_template_args['columns_mobile']) ? $riff_template_args['columns_mobile'] : '' );
} else {
	$riff_template_args = array();
	$riff_blog_style = explode( '_', riff_get_theme_option( 'blog_style' ) );
	$riff_columns    = empty( $riff_blog_style[1] ) ? 2 : max( 1, $riff_blog_style[1] );
    $riff_columns_class = riff_get_column_class( 1, $riff_columns );
}

$riff_post_format = get_post_format();
$riff_post_format = empty( $riff_post_format ) ? 'standard' : str_replace( 'post-format-', '', $riff_post_format );

?><div class="
<?php
if ( ! empty( $riff_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( riff_is_blog_style_use_masonry( $riff_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $riff_columns ) : esc_attr( $riff_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $riff_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $riff_columns )
		. ( 'portfolio' != $riff_blog_style[0] ? ' ' . esc_attr( $riff_blog_style[0] )  . '_' . esc_attr( $riff_columns ) : '' )
	);
	riff_add_blog_animation( $riff_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$riff_hover   = ! empty( $riff_template_args['hover'] ) && ! riff_is_inherit( $riff_template_args['hover'] )
								? $riff_template_args['hover']
								: riff_get_theme_option( 'image_hover' );

	if ( 'dots' == $riff_hover ) {
		$riff_post_link = empty( $riff_template_args['no_links'] )
								? ( ! empty( $riff_template_args['link'] )
									? $riff_template_args['link']
									: get_permalink()
									)
								: '';
		$riff_target    = ! empty( $riff_post_link ) && riff_is_external_url( $riff_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$riff_components = ! empty( $riff_template_args['meta_parts'] )
							? ( is_array( $riff_template_args['meta_parts'] )
								? $riff_template_args['meta_parts']
								: explode( ',', $riff_template_args['meta_parts'] )
								)
							: riff_array_get_keys_by_value( riff_get_theme_option( 'meta_parts' ) );

	// Featured image
	riff_show_post_featured( apply_filters( 'riff_filter_args_featured',
        array(
			'hover'         => $riff_hover,
			'no_links'      => ! empty( $riff_template_args['no_links'] ),
			'thumb_size'    => ! empty( $riff_template_args['thumb_size'] )
								? $riff_template_args['thumb_size']
								: riff_get_thumb_size(
									riff_is_blog_style_use_masonry( $riff_blog_style[0] )
										? (	strpos( riff_get_theme_option( 'body_style' ), 'full' ) !== false || $riff_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( riff_get_theme_option( 'body_style' ), 'full' ) !== false || $riff_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => riff_is_blog_style_use_masonry( $riff_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $riff_components,
			'class'         => 'dots' == $riff_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $riff_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $riff_post_link )
												? '<a href="' . esc_url( $riff_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $riff_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $riff_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $riff_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!