<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package RIFF
 * @since RIFF 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$riff_copyright_scheme = riff_get_theme_option( 'copyright_scheme' );
if ( ! empty( $riff_copyright_scheme ) && ! riff_is_inherit( $riff_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $riff_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$riff_copyright = riff_get_theme_option( 'copyright' );
			if ( ! empty( $riff_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$riff_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $riff_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$riff_copyright = riff_prepare_macros( $riff_copyright );
				// Display copyright
				echo wp_kses( nl2br( $riff_copyright ), 'riff_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
