<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package RIFF
 * @since RIFF 1.0.10
 */

// Footer sidebar
$riff_footer_name    = riff_get_theme_option( 'footer_widgets' );
$riff_footer_present = ! riff_is_off( $riff_footer_name ) && is_active_sidebar( $riff_footer_name );
if ( $riff_footer_present ) {
	riff_storage_set( 'current_sidebar', 'footer' );
	$riff_footer_wide = riff_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $riff_footer_name ) ) {
		dynamic_sidebar( $riff_footer_name );
	}
	$riff_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $riff_out ) ) {
		$riff_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $riff_out );
		$riff_need_columns = true;   //or check: strpos($riff_out, 'columns_wrap')===false;
		if ( $riff_need_columns ) {
			$riff_columns = max( 0, (int) riff_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $riff_columns ) {
				$riff_columns = min( 4, max( 1, riff_tags_count( $riff_out, 'aside' ) ) );
			}
			if ( $riff_columns > 1 ) {
				$riff_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $riff_columns ) . ' widget', $riff_out );
			} else {
				$riff_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $riff_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'riff_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $riff_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $riff_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'riff_action_before_sidebar', 'footer' );
				riff_show_layout( $riff_out );
				do_action( 'riff_action_after_sidebar', 'footer' );
				if ( $riff_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $riff_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'riff_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
