<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package RIFF
 * @since RIFF 1.0.06
 */

$riff_header_css   = '';
$riff_header_image = get_header_image();
$riff_header_video = riff_get_header_video();
if ( ! empty( $riff_header_image ) && riff_trx_addons_featured_image_override( is_singular() || riff_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$riff_header_image = riff_get_current_mode_image( $riff_header_image );
}

$riff_header_id = riff_get_custom_header_id();
$riff_header_meta = get_post_meta( $riff_header_id, 'trx_addons_options', true );
if ( ! empty( $riff_header_meta['margin'] ) ) {
	riff_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( riff_prepare_css_value( $riff_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $riff_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $riff_header_id ) ) ); ?>
				<?php
				echo ! empty( $riff_header_image ) || ! empty( $riff_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $riff_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $riff_header_image ) {
					echo ' ' . esc_attr( riff_add_inline_css_class( 'background-image: url(' . esc_url( $riff_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( riff_is_on( riff_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight riff-full-height';
				}
				$riff_header_scheme = riff_get_theme_option( 'header_scheme' );
				if ( ! empty( $riff_header_scheme ) && ! riff_is_inherit( $riff_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $riff_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $riff_header_video ) ) {
		get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'riff_action_show_layout', $riff_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'riff_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
