<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package RIFF
 * @since RIFF 1.0
 */

$riff_args = get_query_var( 'riff_logo_args' );

// Site logo
$riff_logo_type   = isset( $riff_args['type'] ) ? $riff_args['type'] : '';
$riff_logo_image  = riff_get_logo_image( $riff_logo_type );
$riff_logo_text   = riff_is_on( riff_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$riff_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $riff_logo_image['logo'] ) || ! empty( $riff_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $riff_logo_image['logo'] ) ) {
			if ( empty( $riff_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($riff_logo_image['logo']) && (int) $riff_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$riff_attr = riff_getimagesize( $riff_logo_image['logo'] );
				echo '<img src="' . esc_url( $riff_logo_image['logo'] ) . '"'
						. ( ! empty( $riff_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $riff_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $riff_logo_text ) . '"'
						. ( ! empty( $riff_attr[3] ) ? ' ' . wp_kses_data( $riff_attr[3] ) : '' )
						. '>';
			}
		} else {
			riff_show_layout( riff_prepare_macros( $riff_logo_text ), '<span class="logo_text">', '</span>' );
			riff_show_layout( riff_prepare_macros( $riff_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
