<?php
/**
 * The template to display the widgets area in the header
 *
 * @package RIFF
 * @since RIFF 1.0
 */

// Header sidebar
$riff_header_name    = riff_get_theme_option( 'header_widgets' );
$riff_header_present = ! riff_is_off( $riff_header_name ) && is_active_sidebar( $riff_header_name );
if ( $riff_header_present ) {
	riff_storage_set( 'current_sidebar', 'header' );
	$riff_header_wide = riff_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $riff_header_name ) ) {
		dynamic_sidebar( $riff_header_name );
	}
	$riff_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $riff_widgets_output ) ) {
		$riff_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $riff_widgets_output );
		$riff_need_columns   = strpos( $riff_widgets_output, 'columns_wrap' ) === false;
		if ( $riff_need_columns ) {
			$riff_columns = max( 0, (int) riff_get_theme_option( 'header_columns' ) );
			if ( 0 == $riff_columns ) {
				$riff_columns = min( 6, max( 1, riff_tags_count( $riff_widgets_output, 'aside' ) ) );
			}
			if ( $riff_columns > 1 ) {
				$riff_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $riff_columns ) . ' widget', $riff_widgets_output );
			} else {
				$riff_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $riff_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'riff_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $riff_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $riff_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'riff_action_before_sidebar', 'header' );
				riff_show_layout( $riff_widgets_output );
				do_action( 'riff_action_after_sidebar', 'header' );
				if ( $riff_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $riff_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'riff_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
