<?php
/**
 * The template to display Admin notices
 *
 * @package RIFF
 * @since RIFF 1.0.64
 */

$riff_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$riff_skins_args = get_query_var( 'riff_skins_notice_args' );
?>
<div class="riff_admin_notice riff_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$riff_theme_img = riff_get_file_url( 'screenshot.jpg' );
	if ( '' != $riff_theme_img ) {
		?>
		<div class="riff_notice_image"><img src="<?php echo esc_url( $riff_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'riff' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="riff_notice_title">
		<?php esc_html_e( 'New skins are available', 'riff' ); ?>
	</h3>
	<?php

	// Description
	$riff_total      = $riff_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$riff_skins_msg  = $riff_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $riff_total, 'riff' ), $riff_total ) . '</strong>'
							: '';
	$riff_total      = $riff_skins_args['free'];
	$riff_skins_msg .= $riff_total > 0
							? ( ! empty( $riff_skins_msg ) ? ' ' . esc_html__( 'and', 'riff' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $riff_total, 'riff' ), $riff_total ) . '</strong>'
							: '';
	$riff_total      = $riff_skins_args['pay'];
	$riff_skins_msg .= $riff_skins_args['pay'] > 0
							? ( ! empty( $riff_skins_msg ) ? ' ' . esc_html__( 'and', 'riff' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $riff_total, 'riff' ), $riff_total ) . '</strong>'
							: '';
	?>
	<div class="riff_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'riff' ), $riff_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="riff_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $riff_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			esc_html_e( 'Go to Skins manager', 'riff' );
			?>
		</a>
		<?php
		// Dismiss notice for 7 days
		?>
		<a href="#" role="button" class="button button-secondary riff_notice_button_dismiss" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Dismiss', 'riff' );
			?>
		</a>
		<?php
		// Hide notice forever
		?>
		<a href="#" role="button" class="button button-secondary riff_notice_button_hide" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Never show again', 'riff' );
			?>
		</a>
	</div>
</div>
